CREATE OR REPLACE FUNCTION addTable()
RETURNS VOID AS
$BODY$
BEGIN
    IF EXISTS (SELECT 1 
                 FROM information_schema.columns     
                WHERE table_name= 'est_orc_linx_promo' 
              ) THEN
                         
        RAISE NOTICE 'Tabela est_orc_linx_promo ja existe!' ;
        
    ELSE
        
           Create table public.est_orc_linx_promo (
           	    cd_emp	 				int NOT NULL DEFAULT 0,
				cd_filial 				int NOT NULL DEFAULT 0,
				cd_orc 					int NOT NULL,
				nr_cartao_linx_promo 	varchar(25) NOT NULL,
				vlr_linx_promo 			numeric(14,4) NULL,
				CONSTRAINT est_orc_linx_promo_pkey PRIMARY KEY (cd_emp, cd_filial, cd_orc, nr_cartao_linx_promo)
           	    );
            
	  
			
        RAISE NOTICE 'Tabela  est_orc_linx_promo criada com sucesso!';
    END IF; 
    
END; 
$BODY$
LANGUAGE plpgsql VOLATILE
  COST 100;
ALTER FUNCTION addTable()  OWNER TO postgres;
SELECT addTable();
DROP FUNCTION addTable();